/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc.dimensions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.ftbsbc.FTBStoneBlock;
import dev.ftb.ftbsbc.dimensions.level.DimensionCreatedEvent;
import dev.ftb.ftbsbc.dimensions.level.DimensionStorage;
import dev.ftb.ftbsbc.dimensions.level.DynamicDimensionManager;
import dev.ftb.ftbsbc.dimensions.level.stoneblock.StartStructure;
import dev.ftb.ftbsbc.dimensions.level.stoneblock.StartStructurePiece;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum DimensionsManager {
    INSTANCE;

    private static final Logger LOGGER;
    private static final Random RANDOM;

    @Nullable
    public ResourceKey<Level> getDimension(Player player) {
        Team playerTeam = FTBTeamsAPI.getPlayerTeam((ServerPlayer)((ServerPlayer)player));
        return this.getDimension(playerTeam);
    }

    @Nullable
    public ResourceKey<Level> getDimension(Team team) {
        if (team.getType() != TeamType.PARTY) {
            return null;
        }
        return DimensionStorage.get(team.manager.server).getDimensionId(team);
    }

    public void createDimForTeam(ServerPlayer player, ResourceLocation prebuiltLocation) {
        String dimensionName;
        ResourceKey<Level> dimensionId;
        Team playerTeam = FTBTeamsAPI.getPlayerTeam((ServerPlayer)player);
        if (playerTeam.getType() != TeamType.PARTY) {
            try {
                playerTeam = (Team)FTBTeamsAPI.getManager().createParty(player, player.m_7755_().getString() + " Party").getValue();
            }
            catch (CommandSyntaxException e2) {
                LOGGER.error("Unable to create player team due to " + e2);
                return;
            }
        }
        if ((dimensionId = DimensionStorage.get(player.f_8924_).getDimensionId(playerTeam)) != null) {
            DynamicDimensionManager.teleport(player, dimensionId);
            return;
        }
        List<String> existing = DimensionStorage.get(player.f_8924_).getTeamToDimension().values().stream().map(e -> e.m_135815_().split("/")[1]).toList();
        while (existing.contains(dimensionName = this.generateDimensionName())) {
        }
        ResourceKey<Level> key = DimensionStorage.get(player.f_8924_).putDimension(playerTeam, dimensionName);
        ServerLevel serverLevel = DynamicDimensionManager.create(player.f_8924_, key, prebuiltLocation);
        BlockPos spawnPoint = player.f_8924_.m_129909_().m_163774_(prebuiltLocation).map(structure -> {
            BlockPos blockPos = StartStructure.locateSpawn(structure, StartStructurePiece.makeSettings(structure)).m_142082_(-(structure.m_163801_().m_123341_() / 2), 1, -(structure.m_163801_().m_123343_() / 2));
            BlockPos dimensionSpawnLocations = DimensionStorage.get(player.f_8924_).getDimensionSpawnLocations(serverLevel.m_6018_().m_46472_().m_135782_());
            if (dimensionSpawnLocations == null) {
                DimensionStorage.get(player.f_8924_).addDimensionSpawn(serverLevel.m_6018_().m_46472_().m_135782_(), blockPos);
                FTBStoneBlock.LOGGER.info("Adding spawn to dim storage");
            }
            return blockPos;
        }).orElse(BlockPos.f_121853_);
        DynamicDimensionManager.teleport(player, key);
        player.m_9158_(key, spawnPoint, 0.0f, true, false);
        player.m_150109_().m_6211_();
        player.m_5634_(player.m_21233_());
        FoodData foodData = player.m_36324_();
        foodData.m_150378_(0.0f);
        foodData.m_38705_(20);
        foodData.m_38717_(5.0f);
        MinecraftForge.EVENT_BUS.post((Event)new DimensionCreatedEvent(dimensionName, playerTeam, player, player.f_8924_.m_129880_(key)));
    }

    private String generateDimensionName() {
        CharSequence[] words = new String[3];
        String[] dictionary = this.getDictionary();
        List<Object> shuffledDictionary = new ArrayList();
        if (dictionary != null) {
            shuffledDictionary = Arrays.stream(dictionary).collect(Collectors.toList());
            Collections.shuffle(shuffledDictionary);
        }
        for (int i = 0; i < words.length; ++i) {
            words[i] = !shuffledDictionary.isEmpty() ? (String)shuffledDictionary.get(RANDOM.nextInt(shuffledDictionary.size() - 1)) : RandomStringUtils.randomAlphabetic((int)3, (int)8).toLowerCase();
        }
        return String.join((CharSequence)"-", words);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String[] getDictionary() {
        try (InputStream dictionarySteam = DimensionsManager.class.getResourceAsStream("/assets/%s/dictionary.txt".formatted("ftbsbc"));){
            if (dictionarySteam == null) {
                String[] stringArray2 = null;
                return stringArray2;
            }
            String[] stringArray = new String(dictionarySteam.readAllBytes(), StandardCharsets.UTF_8).split("\n");
            return stringArray;
        }
        catch (IOException e) {
            LOGGER.error("Unable to read dictionary file, defaulting to random strings", (Throwable)e);
            return null;
        }
    }

    static {
        LOGGER = LogManager.getLogger();
        RANDOM = new Random();
    }
}

